﻿//////////////////////////////////////////////
// ShaderMemorySlot.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ShaderMemorySlot : public nkExport::Exportable
	{
		public :
		
			// Constructor
			ShaderMemorySlot () noexcept ;

			// Getters
			nkMemory::StringView getSlotType () const ;
			virtual nkMemory::StringView getDataTypeAsString () const = 0 ;

			// Import / export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;

		protected :
		
			// Attributes
			nkMemory::String _slotType ;
	} ;
}